

<?php $__env->startSection('title', 'Users List'); ?>

<?php $__env->startSection('vendor-styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/css/tables/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/css/tables/datatable/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/app-users.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- users list start -->
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12 col-sm-6 col-lg-3 d-flex align-items-center">
                        <a href="<?php echo e(route('admin.user.create')); ?>"
                            class="btn btn-info btn-block glow users-list-clear mb-0">Add user</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="users-list-table">
            <div class="card">
                <div class="card-body">
                    <!-- datatable start -->
                    <div class="table-responsive">
                        <table id="users-list-datatable" class="table">
                            <thead>
                                <tr>
                                    <th>id</th>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>role</th>
                                    <th>status</th>
                                    <th>edit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->id); ?></td>
                                        <td><a href="<?php echo e(route('admin.user.show',['user'=>$item->id])); ?>"><?php echo e($item->firstName); ?></a> </td>
                                        <td><?php echo e($item->lastName); ?></td>
                                        <td><?php echo e($item->email); ?></td>
                                        <td><?php echo e($item->phone); ?></td>
                                        <td>
                                            <?php if($item->role == 1): ?>
                                                Admin
                                            <?php else: ?>
                                                Client
                                            <?php endif; ?>
                                        </td>
                                        <td><span class="badge badge-light-success">Active</span></td>
                                        <td><a href="<?php echo e(route('admin.user.edit',['user'=>$item->id])); ?>"><i class="bx bx-edit-alt"></i></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- datatable ends -->
                </div>
            </div>
        </div>
    </section>
    <!-- users list ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-scripts'); ?>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/buttons.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-scripts'); ?>
    <script src="<?php echo e(asset('js/scripts/pages/app-users.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\KDS\e-commerce\resources\views/admin/users/index.blade.php ENDPATH**/ ?>